#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;


double timeOfKthOvertake(const vector<double>& velocities, const vector<int>& startingPositions, int k) {
    int n = velocities.size();
    vector<double> timeToOvertake;

    for (int i = 0; i < n; ++i) {
        for (int j = 0 ; j < n; ++j) {
            double relativeVelocity = velocities[j] - velocities[i];
            int razlika = (startingPositions[i] - startingPositions[j]);
            if (relativeVelocity > 0 && razlika > 0) {
                double time = razlika / relativeVelocity;
                timeToOvertake.push_back(time);
            }
        }
    }
    sort(timeToOvertake.begin(), timeToOvertake.end());
    return timeToOvertake[k-1];
}

int main() {
    int n, k, pos;
    cin >> n>>k;
    double vel;
    vector<double> velocities;
    vector<int> startingPositions;
    for (int i = 0; i < n; ++i) {
        cin >> pos >> vel;
        startingPositions.push_back(pos);
        velocities.push_back(vel);
    }
    double time = timeOfKthOvertake(velocities, startingPositions, k);
    cout<<time;
    return 0;
}